set more off
global path_in ""
global path_temp ""
global path_out ""

*	Makes Figure 6


**1. Data prep: Industry prediction contributions to aggregate predictions
use $path_out\Table9_predictions_within, clear	

*Calculate contribution of each industry to weighted mean (the sum of this across industries is the total by country-year)
	foreach var of varlist DE* {
		bysort country year code: gen mean`var'=`var'*weight
	}	
	foreach var of varlist DH* {
		bysort country code year: gen mean`var'=`var'*weight_h
	}	
	foreach var of varlist DYn* DYr* DLS* {
		bysort country code year: gen mean`var'=`var'*weight_VA
	}

	
*Calculate unweighted means across countries
	foreach var of varlist meanDE* {
		bysort code year: egen wt`var'=mean(`var')
	}
	foreach var of varlist meanDH* {
		bysort code year: egen wt`var'=mean(`var')
	}	
	foreach var of varlist meanDYn* meanDYr* meanDLS* {
		bysort code year: egen wt`var'=mean(`var')
	}	
	*Drop country dimension	
	duplicates drop code year, force
	drop country weight*_c
	keep code code_hier year decade wtmean* weight*
		renvars wtmean*, predrop(6)
	table year, c(sum weight_VA)
	
*Calculate unweighted means across years
	collapse (mean) D* weight_VA, by(code code_hier)
	renvars D*, postfix("_i")	
		
	foreach var in E H HW Yn Yr LS{
		label var D`var'_net_i "Industry prediction contribution to aggregate prediction for `var'"
	}
	save $path_temp\temp_predi, replace
	

**2. Data prep: Predictions by industry
use $path_out\Table9_predictions_within, clear	

*Calculate unweighted means across countries
	foreach var of varlist DE* {
		bysort code year: egen wt`var'=mean(`var')
	}
	foreach var of varlist DH* {
		bysort code year: egen wt`var'=mean(`var')
	}	
	foreach var of varlist DYn* DYr* DLS* {
		bysort code year: egen wt`var'=mean(`var')
	}	
	*Drop country dimension	
	duplicates drop code year, force
	drop country weight*_c
	keep code code_hier year decade wt* weight*
		renvars wt*, predrop(2)
	table year, c(sum weight_VA)
	
*Calculate unweighted means across years
	collapse (mean) D* weight_VA, by(code code_hier)
	renvars D*, subst(D Dhat)	
		
	foreach var in E H HW Yn Yr LS {
		label var Dhat`var'_net "Predicted log change in `var' by industry"
	}
	
	save $path_temp\temp_pred, replace	

	
**3. Data prep: Industries' actual contribution to aggregate change*
use $path_in\KLEMS_b2008_clean, clear
	drop if code=="TOT" /*keep sector-specific data*/

	*Set productivity measure as country leave-out TFP
	local LP D1_lnTFPva_oth
		
	*Enforce productivity measure
	rename `LP' D1_LP1_EMP
	
	keep country code sector_short sectorgroup code_hier year D1_lnEMP D1_lnH_EMP D1_lnlaborshare D1_LP1_EMP weight weight_h weight_VA
	sort country code year	

		*Mean across years within countries
		bysort country code: egen tempDls= mean(D1_lnlaborshare) if D1_lnlaborshare!=.
		bysort country code: egen tempDemp= mean(D1_lnEMP) if D1_lnEMP!=.
		bysort country code: egen tempDhrs= mean(D1_lnH_EMP) if D1_lnH_EMP!=.
		bysort country code: egen tempDTFP= mean(D1_LP1_EMP) if D1_LP1_EMP!=.

		drop if tempDls==.|tempDTFP==.|tempDhrs==.|tempDemp==.
		duplicates drop country code, force
		
	*Weight by industry shares to get contributions to aggregate change
	foreach var of varlist tempDemp {
		bysort country year code: gen mean`var'=`var'*weight
	}	
	foreach var of varlist tempDhrs {
		bysort country code year: gen mean`var'=`var'*weight_h
	}	
	foreach var of varlist tempDls {
		bysort country code year: gen mean`var'=`var'*weight_VA
	}
	drop temp*
	renvars mean*, predrop(4)
	 		
		*Merge in country size
		merge m:1 country using $path_in\country_weights
		bysort code: egen meanDemp= mean(tempDemp) 
		bysort code: egen meanDhrs= mean(tempDhrs) 
		bysort code: egen meanDls= mean(tempDls) 
		
		bysort code: egen meanweight_ls=mean(weight_VA)
		bysort code: egen meanweight_hrs=mean(weight_h)
		bysort code: egen meanweight_emp=mean(weight)
		
		drop if meanDls==.|meanDhrs==.|meanDemp==.
		duplicates drop code, force
		keep code code_hier sector_short sectorgroup year mean*
		
		table code_hier, c(mean meanDemp mean meanDhrs mean meanDls)
	
	renvars meanD*, postfix("_i")
	foreach var in emp hrs ls {
		label var meanD`var'_i "Industries' actual contribution to aggregate log change in `var'"
	}	
	drop meanweight* year
save $path_temp\temp_act, replace
	

**4. Data prep: Actual changes by industry 
use $path_in\KLEMS_b2008_clean, clear
	drop if code=="TOT" /*keep sector-specific data*/

	*Set productivity measure as country leave-out TFP
	local LP D1_lnTFPva_oth
		
	*Enforce productivity measure
	rename `LP' D1_LP1_EMP
	
	keep country code sector_short sectorgroup code_hier year D1_lnEMP D1_lnH_EMP D1_lnlaborshare D1_LP1_EMP weight weight_h weight_VA
	sort country code year	
	
	*Weight by country size

		*Mean across years within countries
		bysort country code: egen tempDls= mean(D1_lnlaborshare) if D1_lnlaborshare!=.
		bysort country code: egen tempDemp= mean(D1_lnEMP) if D1_lnEMP!=.
		bysort country code: egen tempDhrs= mean(D1_lnH_EMP) if D1_lnH_EMP!=.
		bysort country code: egen tempDTFP= mean(D1_LP1_EMP) if D1_LP1_EMP!=.

		drop if tempDls==.|tempDTFP==.|tempDhrs==.|tempDemp==.
		duplicates drop country code, force
		
		*Merge in country size
		merge m:1 country using $path_in\country_weights
		bysort code: egen meanDemp= mean(tempDemp) 
		bysort code: egen meanDhrs= mean(tempDhrs) 
		bysort code: egen meanDls= mean(tempDls) 
		bysort code: egen meanDTFP= mean(tempDTFP) 
		
		bysort code: egen meanweight_ls=mean(weight_VA)
		bysort code: egen meanweight_hrs=mean(weight_h)
		bysort code: egen meanweight_emp=mean(weight)
		
		drop if meanDls==.|meanDTFP==.|meanDhrs==.|meanDemp==.
		duplicates drop code, force
		keep code code_hier sector_short sectorgroup year mean*
		
		table code_hier, c(mean meanDemp mean meanDhrs mean meanDls mean meanDTFP)
	
	foreach var in emp hrs ls {
		label var meanD`var' "Industries' actual log change in `var'"
	}	
		drop year

	*Merge results from 4 data prep stages together
	merge 1:1 code using $path_temp\temp_predi
	drop _
	merge 1:1 code using $path_temp\temp_pred
	drop _
	merge 1:1 code using $path_temp\temp_act
	drop _
	drop meanDTFP DHW_net_i DYn_net_i DYr_net_i DhatHW_net DhatYn_net DhatYr_net
	save $path_temp\temp_all, replace


**5. Make Figure 6, top panel
use $path_temp\temp_all, clear

	reg meanDemp DhatE_net [w=meanweight_emp]
		est sto col1
	esttab col1, b(3) se(3) r2(3) stats(r2 N) se star(~ 0.10 * 0.05 ** 0.01) 
	
	gen slabel=sector_short if  code=="F"|code=="52"|code=="51"|code=="C"|code=="15t16"|code=="23"|code=="M"|code=="26"|code=="64"|code=="50"|code=="H"|code=="J"|code=="N"|code=="O"|code=="71t74"|code=="70"|code=="30t33"|code=="24"|code=="21t22"|code=="17t19"|code=="20"|code=="34t35"
	gen pos=12	
	replace pos=3 if code=="30t33" | code=="H"
	replace pos=6 if code=="20"| code=="26" | code=="F"
	replace pos=9 if code=="N" | code=="34t35" | code=="52"
	
	twoway 	(scatter meanDemp  DhatE_net if sectorgroup==1, msymbol(Oh) mcolor(navy) mlabel(slabel) mlabcolor(black) mlabvposition(pos) mlabgap(*.8)) ///
			(scatter meanDemp  DhatE_net if sectorgroup==2, msymbol(d)  mcolor(maroon) mlabel(slabel) mlabcolor(black) mlabvposition(pos) mlabgap(*.8)) ///
			(scatter meanDemp  DhatE_net if sectorgroup==3, msymbol(T)  mcolor(forest_green) mlabel(slabel) mlabcolor(black) mlabvposition(pos) mlabgap(*.8)) ///
			(scatter meanDemp  DhatE_net if sectorgroup==4, msymbol(+)  mcolor(dkorange) mlabel(slabel) mlabcolor(black) mlabvposition(pos) mlabgap(*.8)) ///
			(scatter meanDemp  DhatE_net if sectorgroup==5, msymbol(O)  mcolor(teal) mlabel(slabel) mlabcolor(black) mlabvposition(pos) mlabgap(*.8)  ///
				legend(order(1 "Mining, util's & construction" 2 "Manufacturing" 3 "Education & health" 4 "Low-tech svcs" 5 "High-tech svcs" 6 "Weighted linear fit")) ///
				legend(rows(2)) legend(span) bgcolor(white) plotregion(color(white)) graphregion(color(white)) ///
				ytitle("Observed employment change (log points)") xtitle("Predicted employment change (log points)") ///
				note("Unweighted average across country-years; linear fit is weighted by industries' employment shares," "slope coefficient is 1.925 (standard error 0.539), R2=0.329.", span)) ///
			(lfit meanDemp  DhatE_net [w=meanweight_emp], lcolor(black) )
	graph export "$path_out\Fig6A.eps", as(eps) replace		

	
**6. Make Figure 6, bottom panel
use $path_temp\temp_all, clear
	
	reg meanDemp_i DE_net_i
		est sto col1
	esttab col1, b(3) se(3) r2(3) stats(r2 N) se star(~ 0.10 * 0.05 ** 0.01) 

	gen slabel=sector_short if DE_net_i>0.02 | code=="17t19" | code=="64" | code=="J" | code=="30t33" | code=="52" | code=="51" | code=="15t16" | code=="50" | code=="70" | code=="60t63" | code=="24" | code=="O"
	gen pos=12
	replace pos=3 if code=="15t16" | code=="50"
	replace pos=6 if code=="H"
	replace pos=9 if code=="M" | code=="71t74" | code=="J" | code=="30t33" | code=="60t63" | code=="24"
	
	twoway 	(scatter meanDemp_i DE_net_i if sectorgroup==1, msymbol(Oh) mcolor(navy) mlabel(slabel) mlabcolor(black) mlabvposition(pos) mlabgap(*.8)) ///
			(scatter meanDemp_i DE_net_i if sectorgroup==2, msymbol(d)  mcolor(maroon) mlabel(slabel) mlabcolor(black) mlabvposition(pos) mlabgap(*.8)) ///
			(scatter meanDemp_i DE_net_i if sectorgroup==3, msymbol(T)  mcolor(forest_green) mlabel(slabel) mlabcolor(black) mlabvposition(pos) mlabgap(*.8)) ///
			(scatter meanDemp_i DE_net_i if sectorgroup==4, msymbol(+)  mcolor(dkorange) mlabel(slabel) mlabcolor(black) mlabvposition(pos) mlabgap(*.8)) ///
			(scatter meanDemp_i DE_net_i if sectorgroup==5, msymbol(O)  mcolor(teal) mlabel(slabel) mlabcolor(black) mlabvposition(pos) mlabgap(*.8)  ///
				legend(order(1 "Mining, util's & construction" 2 "Manufacturing" 3 "Education & health" 4 "Low-tech svcs" 5 "High-tech svcs" 6 "Linear fit")) ///
				legend(rows(2)) legend(span) bgcolor(white) plotregion(color(white)) graphregion(color(white)) ///
				ytitle("Contribution to observed aggregate" "employment change (log points)") xtitle("Contribution to predicted aggregate employment change (log points)") ///
				note("Unweighted average across country-years; linear fit is unweighted, slope coefficient is 2.676" "(standard error 0.418), R2=0.612.", span)) ///
				(lfit meanDemp_i DE_net_i, lcolor(black) )
	graph export "$path_out\Fig6B.eps", as(eps) replace			

	
	
*Erase temporary files
	foreach var in all predi pred act {	
	erase $path_temp\temp_`var'.dta
	}
